import numpy as np

from matrx.actions.action import Action, ActionResult
from matrx.actions.object_actions import GrabObject, DropObject
from matrx.utils import get_distance
from matrx.objects import EnvObject

# agent ids
robot_id = 'robot'
human_id = 'human'
# agent scores
human_score = 0
robot_score = 0
# dropzone locations
dropzone = []
for i in range(24):
    dropzone.append((i, 0))
# safezone locations
safezone = [(10, 3), (11, 3), (12, 3), (13, 3), (14, 3), (10, 4), (11, 4), (12, 4), (13, 4), (14, 4), (10, 5),
                    (11, 5), (12, 5), (13, 5), (14, 5)]

class CarryObject(GrabObject):

    def __init__(self, duration_in_ticks=1):
        super().__init__(duration_in_ticks)

    def is_possible(self, grid_world, agent_id, world_state, **kwargs):
        grab_range = np.inf if 'grab_range' not in kwargs else kwargs['grab_range']
        if agent_id == "human":
            other_agent = grid_world.registered_agents["robot"]
        else:
            other_agent = grid_world.registered_agents["human"]
        obj_to_grab = world_state[kwargs["object_id"]]
        agent = grid_world.registered_agents[agent_id]

        # check if the collaborating agent is close enough to the object as well
        if obj_to_grab:
            if obj_to_grab['weight'] == 'heavy':
                if get_distance(other_agent.location, obj_to_grab['location']) > grab_range:
                    # if agent_id == "human":
                    #     agent.change_property("img_name", "human_help.png")
                    # else:
                    #     agent.change_property("img_name", "robot_help.png")
                    return CarryTogetherResult(CarryTogetherResult.OTHER_TOO_FAR, False)
                # if agent_id == "human":
                #     agent.change_property("img_name", "human.png")
                # else:
                #     agent.change_property("img_name", "robot.png")
                agent_id = 'human'
        else:
            return CarryTogetherResult(CarryTogetherResult.OTHER_TOO_FAR, False)
        # do the checks for grabbing a regular object as well
        return super().is_possible(grid_world, agent_id, world_state, **kwargs)

    def mutate(self, grid_world, agent_id, world_state, **kwargs):
        # get robot and human ids
        global robot_id
        global human_id
        # get the object that the agent wants to grab
        obj_to_grab = world_state[kwargs["object_id"]]
        # get the robot and human
        robot = grid_world.registered_agents[robot_id]
        human = grid_world.registered_agents[human_id]

        # if the box is heavy, they have to carry it together
        if obj_to_grab.get('weight') == "heavy":
            # make the other agent invisible
            robot.change_property("visualize_opacity", 0)
            # change our image
            if obj_to_grab.get('owner') == "robot":
                human.change_property("img_name", "together_heavy_box_robot.png")
            else:
                human.change_property("img_name", "together_heavy_box_human.png")
        # if the box is light, check which agent wants to carry it
        elif robot_id == agent_id:
            # change our image
            if obj_to_grab.get('owner') == "robot":
                robot.change_property("img_name", "robot_light_box_robot.png")
            else:
                robot.change_property("img_name", "robot_light_box_human.png")
        else:
            # change our image
            if obj_to_grab.get('owner') == "robot":
                human.change_property("img_name", "human_light_box_robot.png")
            else:
                human.change_property("img_name", "human_light_box_human.png")
        # pickup the object
        return super().mutate(grid_world, agent_id, world_state, **kwargs)


class LowerObject(DropObject):
    def __init__(self, duration_in_ticks=0):
        super().__init__(duration_in_ticks)

    def mutate(self, grid_world, agent_id, world_state, **kwargs):
        # get robot and human ids
        global robot_id
        global human_id
        # get scores
        global human_score
        global robot_score
        global dropzone
        global safezone
        # get the robot and human
        robot = grid_world.registered_agents[robot_id]
        human = grid_world.registered_agents[human_id]

        # if the agent was invisible because of the heavy object, get them back
        if robot.visualize_opacity == 0.0:
            # teleport the other agent to our current position
            robot.change_property("location", human.properties['location'])
            # make the other agent visible again
            robot.change_property("visualize_opacity", 1)
            robot.change_property("img_name", "robot.png")
            human.change_property("img_name", "human.png")
        # if they're carrying alone
        # change the agent image back to default
        if agent_id == robot_id:
            robot.change_property("img_name", "robot.png")
            obj = robot.is_carrying[0]
            drop_loc = robot.location
        elif agent_id == human_id:
            human.change_property("img_name", "human.png")
            obj = human.is_carrying[0]
            drop_loc = human.location
        # give box a destination
        if 'destination' in kwargs:
            dest = kwargs['destination']
            # check if object already had a destination (for example because it was put down in safezone)
            if not 'destination' in obj.properties:
                obj.add_property("destination", dest)
            else: obj.change_property('destination', dest)

        # get all ghostboxes
        ghostboxes = dict(filter(lambda elem: elem[0].startswith('ghostbox'), grid_world.environment_objects.items()))
        # filter so there are no broken boxes in the ghostboxes
        no_broken_ghostboxes = dict(filter(
                lambda elem: elem[1].properties['name'] == 'ghostbox', ghostboxes.items()))
        if drop_loc not in dropzone + safezone:

            # filter the ghostboxes to fit the properties of the box
            filtered_ghostboxes = dict(filter(
                lambda elem: elem[1].properties['weight'] == obj.properties['weight'] and elem[1].properties['owner'] ==
                             obj.properties['owner'], no_broken_ghostboxes.items()))
            # get the first in line
            ghostbox = min(filtered_ghostboxes.items(), key=lambda elem: elem[1].properties['number'])[1]
            obj.change_property("name", "broken")
            ghostbox.change_property("name", "ghostbroken")
            # check which box was being carried
            if obj.properties["owner"] == "human":
                if obj.properties["weight"] == "heavy":
                    obj.change_property("img_name", "broken_heavy_box_human.png")
                    ghostbox.change_property("img_name", "broken_heavy_box_human.png")
                else:
                    obj.change_property("img_name", "broken_light_box_human.png")
                    ghostbox.change_property("img_name", "broken_light_box_human.png")
            else:
                if obj.properties["weight"] == "heavy":
                    obj.change_property("img_name", "broken_heavy_box_robot.png")
                    ghostbox.change_property("img_name", "broken_heavy_box_robot.png")
                else:
                    obj.change_property("img_name", "broken_light_box_robot.png")
                    ghostbox.change_property("img_name", "broken_light_box_robot.png")
            obj.change_property("is_movable", False)
            obj.change_property("visualize_opacity", 0.5)
        else:
            # check on which ghostbox the box is being dropped
            drop_loc_ghostbox = dict(filter(lambda elem: elem[1].properties['location'] == drop_loc, no_broken_ghostboxes.items()))
            # get the first
            drop_loc_ghostbox = list(drop_loc_ghostbox.values())[0] if drop_loc_ghostbox else None
            # if the properties fit, accept drop
            if drop_loc_ghostbox:
                if obj.properties['owner'] == drop_loc_ghostbox.properties['owner'] and obj.properties['weight'] == drop_loc_ghostbox.properties['weight']:
                    # keep score
                    first_up = min(no_broken_ghostboxes.items(), key=lambda elem: elem[1].properties['number'])[1]
                    if first_up == drop_loc_ghostbox:
                        if obj.properties['owner'] == 'human':
                            human_score += 10
                            human.change_property('score', human_score)
                        else:
                            robot_score += 10
                            robot.change_property('score', robot_score)
                    obj.change_property("is_movable", False)
                    obj.change_property("name", "placed")
                    drop_loc_ghostbox.change_property("name", "ghostplaced")

        return super().mutate(grid_world, agent_id, world_state, **kwargs)


class CarryTogetherResult(ActionResult):
    PICKUP_SUCCESS = 'Successfully grabbed object together'
    OTHER_TOO_FAR = 'Failed to grab object. The other agent is too far from the object'
    MAX_OBJECTS_EXCEEDED = 'Already carrying a box'
    OUT_OF_RANGE = 'Agent indicating pickup is out of grabbing range for object'